<?php

namespace app\controllers;

use app\models\Application;
use app\models\ApplicationForm;
use app\models\CommentForm;
use app\models\Tour;
use Yii;
use yii\helpers\ArrayHelper;
use yii\web\Controller;

class ApplicationController extends Controller
{
    public function actionIndex()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $applications = Application::find()->where(['user_id' => Yii::$app->user->identity->id])->orderBy(['id' => SORT_DESC])->all();
        return $this->render('index', ['applications' => $applications]);
    }

    public function actionCreate()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $tours = ArrayHelper::map(Tour::find()->all(), 'id', 'title');
        $model = new ApplicationForm();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Заявка отправлена');
            return $this->redirect(['index']);
        }
        return $this->render('create', ['model' => $model, 'tours' => $tours]);
    }

    public function actionComment()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $tours = ArrayHelper::map(Tour::find()->all(), 'id', 'title');
        $model = new CommentForm();
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Ваш комментарий отправлен');
        }
        return $this->render('comment', ['model' => $model, 'tours' => $tours]);
    }
}