<?php

namespace app\models;

use Yii;
use yii\base\Model;

class ApplicationForm extends Model
{
    public $tour_id;
    public $date_start;
    public $date_end;
    public $count;
    public $additional;
    public $payment;

    public function rules()
    {
        return [
            [['tour_id', 'date_start', 'date_end', 'count', 'payment'], 'required'],
            [['tour_id', 'count', 'payment'], 'integer'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'tour_id' => 'Тур',
            'date_start' => 'Дата начала',
            'date_end' => 'Дата окончания',
            'count' => 'Количество участников',
            'additional' => 'Дополнительные пожелания',
            'payment' => 'Способ оплаты',
        ];
    }

    public function save()
    {
        if ($this->validate()) {
            $application = new Application();
            $application->tour_id = $this->tour_id;
            $application->date_start = $this->date_start;
            $application->date_end = $this->date_end;
            $application->count = $this->count;
            $application->additional = $this->additional;
            $application->payment = $this->payment;
            $application->user_id = Yii::$app->user->identity->id;
            if ($application->save()) {
                return $application;
            }
        }
        return false;
    }
}
