<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

class ApplicationSearch extends Application
{
    public $tourTitle;
    public $userName;

    public function rules()
    {
        return [
            [['id', 'tour_id', 'count', 'payment', 'user_id', 'status'], 'integer'],
            [['date_start', 'date_end', 'additional', 'tourTitle', 'userName'], 'safe'],
        ];
    }

    public function search($params)
    {
        $query = Application::find()
            ->joinWith(['tour', 'user']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 20,
            ],
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ],
                'attributes' => [
                    'id',
                    'date_start',
                    'date_end',
                    'status',
                    'tourTitle' => [
                        'asc' => ['tour.title' => SORT_ASC],
                        'desc' => ['tour.title' => SORT_DESC],
                    ],
                    'userName' => [
                        'asc' => ['user.username' => SORT_ASC],
                        'desc' => ['user.username' => SORT_DESC],
                    ],
                ],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        $query->andFilterWhere([
            'application.id' => $this->id,
            'application.tour_id' => $this->tour_id,
            'application.count' => $this->count,
            'application.payment' => $this->payment,
            'application.user_id' => $this->user_id,
            'application.status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'additional', $this->additional])
            ->andFilterWhere(['like', 'tour.title', $this->tourTitle])
            ->andFilterWhere(['like', 'user.username', $this->userName])
            ->andFilterWhere(['>=', 'date_start', $this->date_start])
            ->andFilterWhere(['<=', 'date_end', $this->date_end]);

        return $dataProvider;
    }
}