<?php

namespace app\models;

use Yii;
use yii\base\Model;

class CommentForm extends Model
{
    public $tour_id;
    public $text;

    public function rules()
    {
        return [
            [['text', 'tour_id'], 'required'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'tour_id' => 'Комментарий',
            'text' => 'Комментарий',
        ];
    }

    public function save()
    {
        if ($this->validate()) {
            $comment = new Comment();
            $comment->text = $this->text;
            $comment->tour_id = $this->tour_id;
            $comment->user_id = Yii::$app->user->identity->id;
            if ($comment->save()) {
                return $comment;
            }
        }
        return false;
    }
}
