<?php

namespace app\models;


use yii\db\ActiveRecord;

class User extends ActiveRecord implements \yii\web\IdentityInterface
{
    public $authKey;
    public $accessToken;

    public function rules()
    {
        return [
            [['first_name', 'last_name', 'patronymic', 'phone', 'email', 'passport', 'address'], 'required'],
            [['email'], 'email'],
            [['email'], 'unique', 'message' => 'Этот email уже зарегистрирован.'],
            [['first_name', 'last_name', 'patronymic'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u'],
            [['is_admin'], 'boolean'],
            [['is_admin'], 'default', 'value' => 0],
        ];
    }

    public function attributeLabels()
    {
        return [
            'first_name' => 'Имя',
            'last_name' => 'Фамилия',
            'patronymic' => 'Отчество',
            'phone' => 'Телефон',
            'passport' => 'Паспорт',
            'address' => 'Адрес',
            'is_admin' => 'Админ',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function findIdentity($id)
    {
        return static::findOne($id);
    }

    /**
     * {@inheritdoc}
     */
    public static function findIdentityByAccessToken($token, $type = null)
    {
        return null;
    }

    /**
     * Finds user by username
     *
     * @param string $username
     * @return static|null
     */
    public static function findByEmail($email)
    {
        return static::findOne(['email' => $email]);
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }

    /**
     * {@inheritdoc}
     */
    public function validateAuthKey($authKey)
    {
        return $this->authKey === $authKey;
    }

    /**
     * Validates password
     *
     * @param string $password password to validate
     * @return bool if password provided is valid for current user
     */
    public function validatePassword($password)
    {
        return \Yii::$app->getSecurity()->validatePassword($password, $this->password);
    }

    public function getFullName()
    {
        return trim($this->last_name . ' ' . $this->first_name . ' ' . $this->patronymic);
    }
}
