<?php
use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Application;

$this->title = 'Заявки';
$this->params['breadcrumbs'][] = $this->title;
?>

<?php $this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
<?php $this->registerCssFile('https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&display=swap') ?>

<style>
:root {
    --bg: #fcfdfd;
    --surface: #ffffff;
    --text: #2a2f3a;
    --text-light: #6c757d;
    --primary: #4ecdc4;
    --primary-light: #b0e5e1;
    --secondary: #6c5ce7;
    --success: #2ecc71;
    --pending: #ffd166;
    --shadow-sm: 0 4px 12px rgba(0,0,0,0.03);
    --shadow-md: 0 8px 24px rgba(0,0,0,0.05);
    --radius: 20px;
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Manrope', sans-serif;
    background-color: var(--bg);
    color: var(--text);
}

.admin-applications {
    min-height: calc(100vh - 160px);
    padding: 50px 0;
}

.admin-container {
    max-width: 1300px;
    margin: 0 auto;
    padding: 0 20px;
}

.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 40px;
}

.page-title {
    font-size: 2.4rem;
    font-weight: 700;
    background: linear-gradient(135deg, var(--text), var(--primary));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    display: inline-block;
}

.page-stats {
    display: flex;
    gap: 24px;
}

.stat-card {
    background: var(--surface);
    padding: 16px 24px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    min-width: 110px;
    text-align: center;
}

.stat-number {
    font-size: 1.8rem;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: var(--text-light);
    margin-top: 4px;
}

/* Filters */
.filters-card {
    background: var(--surface);
    border-radius: var(--radius);
    box-shadow: var(--shadow-sm);
    margin-bottom: 36px;
    overflow: hidden;
}

.filters-header {
    padding: 24px 30px;
    background: var(--primary-light);
    color: var(--primary);
}

.filters-title {
    font-size: 1.25rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 12px;
}

.filters-body {
    padding: 28px 30px;
}

.filters-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 20px;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.filter-label {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--text);
}

.filter-select {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid #e0e6eb;
    border-radius: 12px;
    font-size: 0.95rem;
    background: white;
    appearance: none;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%234ecdc4' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    background-size: 14px 10px;
}

.filter-select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(78, 205, 196, 0.15);
}

.filter-actions {
    display: flex;
    gap: 16px;
    grid-column: 1 / -1;
    margin-top: 12px;
}

.btn {
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: var(--transition);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    text-align: center;
}

.btn-primary {
    background: var(--primary);
    color: white;
    border: 2px solid var(--primary);
}

.btn-primary:hover {
    background: #3aada0;
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(78, 205, 196, 0.25);
}

.btn-outline {
    background: white;
    color: var(--text);
    border: 2px solid #e0e6eb;
}

.btn-outline:hover {
    border-color: var(--primary);
    color: var(--primary);
    transform: translateY(-3px);
}

/* Table */
.table-container {
    background: var(--surface);
    border-radius: var(--radius);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
}

table {
    width: 100%;
    border-collapse: collapse;
}

thead {
    background: #fafbfd;
}

th {
    padding: 20px 16px;
    text-align: left;
    font-weight: 600;
    color: var(--text-light);
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

td {
    padding: 18px 16px;
    border-bottom: 1px solid #f0f2f5;
    color: var(--text);
    font-size: 0.95rem;
}

tr:last-child td {
    border-bottom: none;
}

tr:hover {
    background: #fafbfd;
}

/* Badges */
.badge {
    padding: 6px 14px;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    display: inline-block;
}

.badge-payment-card {
    background: rgba(46, 204, 113, 0.15);
    color: #2ecc71;
}

.badge-payment-cash {
    background: rgba(255, 209, 102, 0.3);
    color: #d9a500;
}

.btn-view {
    padding: 8px 18px;
    background: var(--primary-light);
    color: var(--primary);
    border-radius: 10px;
    font-size: 0.9rem;
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
}

.btn-view:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-2px);
}

/* Pagination */
.pagination {
    display: flex;
    justify-content: center;
    padding: 24px;
    background: #fafbfd;
    border-top: 1px solid #f0f2f5;
}

.pagination li {
    margin: 0 4px;
}

.pagination a,
.pagination span {
    padding: 8px 16px;
    border-radius: 8px;
    color: var(--primary);
    text-decoration: none;
    font-weight: 500;
}

.pagination a:hover {
    background: var(--primary-light);
}

.pagination .active span {
    background: var(--primary);
    color: white;
}

/* Animations */
.fade-in {
    opacity: 0;
    transform: translateY(20px);
}

.fade-in.visible {
    opacity: 1;
    transform: translateY(0);
    transition: opacity 0.5s ease, transform 0.5s ease;
}

/* Responsive */
@media (max-width: 992px) {
    .page-header { flex-direction: column; align-items: flex-start; gap: 20px; }
    .page-stats { width: 100%; justify-content: space-between; }
    .filters-form { grid-template-columns: 1fr; }
}

@media (max-width: 768px) {
    .admin-container { padding: 0 15px; }
    .page-title { font-size: 2rem; }
    .filters-header, .filters-body { padding: 20px; }
    .stat-card { padding: 14px 20px; }
    .stat-number { font-size: 1.5rem; }
}

@media (max-width: 576px) {
    .page-stats { flex-direction: column; width: 100%; }
    .stat-card { width: 100%; }
    .filter-actions { flex-direction: column; }
    .btn { width: 100%; justify-content: center; }
    th, td { padding: 14px 10px; font-size: 0.9rem; }
}
</style>

<div class="admin-applications">
    <div class="admin-container">
        <div class="page-header">
            <h1 class="page-title">Управление заявками</h1>
            <div class="page-stats">
                <div class="stat-card">
                    <div class="stat-number"><?= $dataProvider->getTotalCount() ?></div>
                    <div class="stat-label">Всего</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number"><?= Application::find()->count() ?></div>
                    <div class="stat-label">Все</div>
                </div>
            </div>
        </div>

        <div class="filters-card fade-in" id="filtersCard">
            <div class="filters-header">
                <h2 class="filters-title"><i class="fas fa-filter"></i> Фильтры</h2>
            </div>
            <div class="filters-body">
                <form method="get" class="filters-form">
                    <div class="filter-group">
                        <label class="filter-label">Тур</label>
                        <select name="tour_id" class="filter-select">
                            <option value="">Все туры</option>
                            <?php foreach ($tours as $tour): ?>
                                <option value="<?= $tour->id ?>" <?= Yii::$app->request->get('tour_id') == $tour->id ? 'selected' : '' ?>>
                                    <?= Html::encode($tour->title) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="filter-group">
                        <label class="filter-label">Сортировка</label>
                        <select name="sort" class="filter-select">
                            <option value="-id" <?= Yii::$app->request->get('sort') == '-id' ? 'selected' : '' ?>>Новые первыми</option>
                            <option value="id" <?= Yii::$app->request->get('sort') == 'id' ? 'selected' : '' ?>>Старые первыми</option>
                            <option value="date_start" <?= Yii::$app->request->get('sort') == 'date_start' ? 'selected' : '' ?>>Начало: ↑</option>
                            <option value="-date_start" <?= Yii::$app->request->get('sort') == '-date_start' ? 'selected' : '' ?>>Начало: ↓</option>
                        </select>
                    </div>

                    <div class="filter-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check"></i> Применить
                        </button>
                        <?= Html::a('<i class="fas fa-redo"></i> Сбросить', ['applications'], ['class' => 'btn btn-outline']) ?>
                    </div>
                </form>
            </div>
        </div>

        <div class="table-container fade-in" id="tableCard">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'tableOptions' => ['class' => 'table'],
                'layout' => "{items}\n{pager}",
                'columns' => [
                    [
                        'class' => 'yii\grid\SerialColumn',
                        'header' => '#',
                        'contentOptions' => ['style' => 'width: 50px; font-weight: 500;']
                    ],
                    [
                        'attribute' => 'id',
                        'header' => 'ID',
                        'contentOptions' => ['style' => 'font-weight: 600; width: 80px;']
                    ],
                    [
                        'attribute' => 'tour_id',
                        'header' => 'Тур',
                        'value' => fn($model) => $model->tour ? Html::encode($model->tour->title) : '—'
                    ],
                    [
                        'attribute' => 'user_id',
                        'header' => 'Пользователь',
                        'value' => fn($model) => $model->user ? Html::encode($model->user->getFullName()) : 'Гость'
                    ],
                    [
                        'attribute' => 'date_start',
                        'header' => 'Начало',
                        'format' => 'date',
                        'contentOptions' => ['style' => 'white-space: nowrap; width: 120px;']
                    ],
                    [
                        'attribute' => 'date_end',
                        'header' => 'Окончание',
                        'format' => 'date',
                        'contentOptions' => ['style' => 'white-space: nowrap; width: 120px;']
                    ],
                    [
                        'attribute' => 'count',
                        'header' => 'Участники',
                        'contentOptions' => ['style' => 'text-align: center; font-weight: 600; width: 100px;']
                    ],
                    [
                        'attribute' => 'payment',
                        'header' => 'Оплата',
                        'value' => fn($model) => Html::tag('span', $model->payment ? 'Картой' : 'Наличными', [
                            'class' => 'badge ' . ($model->payment ? 'badge-payment-card' : 'badge-payment-cash')
                        ]),
                        'format' => 'raw'
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Действия',
                        'template' => '{view}',
                        'buttons' => [
                            'view' => fn($url, $model) => Html::a('<i class="fas fa-eye"></i> Просмотр', ['view-application', 'id' => $model->id], [
                                'class' => 'btn-view'
                            ])
                        ],
                        'contentOptions' => ['style' => 'text-align: center; width: 120px;']
                    ],
                ],
            ]); ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Анимация появления
    setTimeout(() => {
        document.getElementById('filtersCard').classList.add('visible');
        document.getElementById('tableCard').classList.add('visible');
    }, 100);
});
</script>