<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\helpers\Url;

$this->title = 'Оформление заявки';
?>

<?php $this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
<?php $this->registerCssFile('https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&display=swap') ?>

<style>
:root {
    --bg: #fcfdfd;
    --surface: #ffffff;
    --text: #2a2f3a;
    --text-light: #6c757d;
    --primary: #4ecdc4;
    --primary-light: #b0e5e1;
    --accent: #ffd166;
    --shadow-sm: 0 4px 12px rgba(0,0,0,0.03);
    --shadow-md: 0 8px 24px rgba(0,0,0,0.05);
    --radius: 20px;
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Manrope', sans-serif;
    background-color: var(--bg);
    color: var(--text);
}

.application-page {
    min-height: calc(100vh - 160px);
    padding: 60px 0;
}

.application-container {
    max-width: 1100px;
    margin: 0 auto;
    padding: 0 20px;
}

.app-card {
    background: var(--surface);
    border-radius: var(--radius);
    box-shadow: var(--shadow-md);
    display: grid;
    grid-template-columns: 300px 1fr;
    gap: 0;
    overflow: hidden;
}

/* Левая панель — информация */
.app-info {
    background: linear-gradient(135deg, var(--primary), #2a7a87);
    color: white;
    padding: 40px;
    display: flex;
    flex-direction: column;
}

.app-info h2 {
    font-size: 1.6rem;
    font-weight: 700;
    margin-bottom: 16px;
}

.app-info p {
    font-size: 0.95rem;
    opacity: 0.9;
    line-height: 1.6;
    margin-bottom: 30px;
}

.benefits {
    margin: 30px 0;
}

.benefit {
    display: flex;
    gap: 12px;
    margin-bottom: 24px;
    font-size: 0.95rem;
}

.benefit-icon {
    width: 36px;
    height: 36px;
    background: rgba(255,255,255,0.2);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.progress-bar {
    margin-top: auto;
    padding-top: 30px;
    border-top: 1px solid rgba(255,255,255,0.2);
}

.progress-steps {
    display: flex;
    justify-content: space-between;
    position: relative;
    margin-bottom: 12px;
}

.progress-steps::before {
    content: '';
    position: absolute;
    top: 16px;
    left: 10px;
    right: 10px;
    height: 4px;
    background: rgba(255,255,255,0.2);
    border-radius: 2px;
}

.progress-step {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    background: rgba(255,255,255,0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
    font-weight: 600;
    position: relative;
    z-index: 1;
}

.progress-step.completed {
    background: var(--accent);
    color: var(--text);
}

.progress-step.active {
    background: var(--accent);
    color: var(--text);
    transform: scale(1.1);
}

.progress-labels {
    display: flex;
    justify-content: space-between;
    font-size: 0.8rem;
    opacity: 0.8;
}

/* Правая панель — форма */
.app-form {
    padding: 50px 60px;
    max-height: 700px;
    overflow-y: auto;
}

.form-header {
    text-align: center;
    margin-bottom: 40px;
}

.form-logo {
    width: 70px;
    height: 70px;
    background: var(--primary-light);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    color: var(--primary);
    font-size: 1.8rem;
}

.form-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 10px;
}

.form-subtitle {
    color: var(--text-light);
    font-size: 1rem;
}

.form-section {
    margin-bottom: 36px;
}

.form-section-title {
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--text);
}

.form-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.form-control,
.form-select {
    width: 100%;
    padding: 14px 18px;
    border: 1px solid #e0e6eb;
    border-radius: 12px;
    font-size: 0.95rem;
    background: white;
    transition: var(--transition);
}

.form-control:focus,
.form-select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(78, 205, 196, 0.15);
}

.form-group {
    margin-bottom: 22px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    font-size: 0.95rem;
    color: var(--text);
}

.input-with-icon {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--text-light);
}

.input-with-icon .form-control {
    padding-left: 50px;
}

/* Tour preview */
.tour-preview {
    background: var(--primary-light);
    border-radius: 12px;
    padding: 18px;
    margin-top: 16px;
    display: none;
}

.tour-preview.active {
    display: block;
}

.tour-preview h5 {
    font-weight: 600;
    margin-bottom: 8px;
    color: var(--text);
}

/* Payment options */
.payment-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 16px;
    margin-top: 12px;
}

.payment-option label {
    display: flex;
    gap: 14px;
    padding: 16px;
    border: 1px solid #e0e6eb;
    border-radius: 14px;
    cursor: pointer;
    transition: var(--transition);
}

.payment-option input {
    display: none;
}

.payment-option input:checked + label {
    border-color: var(--primary);
    background: rgba(78, 205, 196, 0.05);
}

.payment-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--primary-light);
    color: var(--primary);
    font-size: 1.2rem;
    flex-shrink: 0;
}

.payment-cash .payment-icon {
    background: #ffe6cc;
    color: #ff8c00;
}

.payment-info h5 {
    font-weight: 600;
    font-size: 1rem;
    margin-bottom: 4px;
}

.payment-info p {
    color: var(--text-light);
    font-size: 0.85rem;
    margin: 0;
}

/* Textarea */
.textarea-container {
    position: relative;
}

.textarea-container textarea {
    min-height: 120px;
    padding: 14px 18px;
    resize: vertical;
}

.char-counter {
    position: absolute;
    bottom: 10px;
    right: 15px;
    font-size: 0.8rem;
    color: var(--text-light);
}

/* Price summary */
.price-summary {
    background: rgba(78, 205, 196, 0.05);
    border: 1px solid var(--primary-light);
    border-radius: 14px;
    padding: 20px;
    margin-top: 24px;
}

.price-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 12px;
    color: var(--text);
}

.price-row.total {
    font-weight: 700;
    color: var(--primary);
    padding-top: 16px;
    margin-top: 16px;
    border-top: 1px solid var(--primary-light);
}

/* Submit button */
.submit-btn {
    width: 100%;
    padding: 16px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 14px;
    font-weight: 600;
    font-size: 1.05rem;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}

.submit-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(78, 205, 196, 0.25);
}

/* Errors */
.invalid-feedback {
    display: none;
    color: #e74c3c;
    font-size: 0.85rem;
    margin-top: 6px;
}

.form-control.is-invalid {
    border-color: #e74c3c;
}

/* Responsive */
@media (max-width: 992px) {
    .app-card {
        grid-template-columns: 1fr;
        max-width: 700px;
        margin: 0 auto;
    }
    .app-info {
        padding: 30px;
    }
    .app-form {
        padding: 40px 30px;
    }
}

@media (max-width: 768px) {
    .form-row {
        grid-template-columns: 1fr;
    }
    .payment-options {
        grid-template-columns: 1fr;
    }
    .form-title {
        font-size: 1.6rem;
    }
}

@media (max-width: 576px) {
    .app-form {
        padding: 30px 20px;
    }
    .form-logo {
        width: 60px;
        height: 60px;
        font-size: 1.4rem;
    }
}
</style>

<div class="application-page">
    <div class="application-container">
        <div class="app-card">
            <!-- Информация -->
            <div class="app-info">
                <h2>Бронирование тура</h2>
                <p>Заполните форму ниже, чтобы забронировать путешествие вашей мечты. Мы свяжемся с вами для подтверждения.</p>

                <div class="benefits">
                    <div class="benefit">
                        <div class="benefit-icon"><i class="fas fa-lock"></i></div>
                        <div>Безопасная оплата с защитой SSL</div>
                    </div>
                    <div class="benefit">
                        <div class="benefit-icon"><i class="fas fa-headset"></i></div>
                        <div>Поддержка 24/7</div>
                    </div>
                    <div class="benefit">
                        <div class="benefit-icon"><i class="fas fa-check-circle"></i></div>
                        <div>Мгновенное подтверждение</div>
                    </div>
                    <div class="benefit">
                        <div class="benefit-icon"><i class="fas fa-gift"></i></div>
                        <div>Бонусы и скидки</div>
                    </div>
                </div>

                <div class="progress-bar">
                    <div class="progress-steps">
                        <div class="progress-step completed">1</div>
                        <div class="progress-step active">2</div>
                        <div class="progress-step">3</div>
                        <div class="progress-step">4</div>
                    </div>
                    <div class="progress-labels">
                        <span>Тур</span>
                        <span>Данные</span>
                        <span>Оплата</span>
                        <span>Готово</span>
                    </div>
                </div>
            </div>

            <!-- Форма -->
            <div class="app-form">
                <div class="form-header">
                    <div class="form-logo"><i class="fas fa-plane"></i></div>
                    <h2 class="form-title">Оформление заявки</h2>
                    <p class="form-subtitle">Заполните все необходимые поля</p>
                </div>

                <?php $form = ActiveForm::begin([
                    'id' => 'application-form',
                    'options' => ['class' => 'custom-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'errorOptions' => ['class' => 'invalid-feedback'],
                    ],
                ]); ?>

                <!-- Тур -->
                <div class="form-section">
                    <h3 class="form-section-title"><i class="fas fa-compass"></i> Выбор тура</h3>
                    <div class="form-group">
                        <?= $form->field($model, 'tour_id')->dropDownList(
                            $tours,
                            [
                                'prompt' => 'Выберите тур...',
                                'class' => 'form-select',
                                'id' => 'tourSelect'
                            ]
                        )->label('Тур') ?>
                    </div>

                    <div class="tour-preview" id="tourPreview">
                        <h5 id="previewTitle">Название тура</h5>
                        <div><strong id="previewPrice">0 ₽</strong> • <span id="previewDuration">7 дней</span></div>
                    </div>
                </div>

                <!-- Даты и участники -->
                <div class="form-section">
                    <h3 class="form-section-title"><i class="far fa-calendar-alt"></i> Даты и участники</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Дата начала</label>
                            <div class="input-with-icon">
                                <i class="fas fa-calendar input-icon"></i>
                                <?= Html::activeInput('date', $model, 'date_start', ['class' => 'form-control']) ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Дата окончания</label>
                            <div class="input-with-icon">
                                <i class="fas fa-calendar input-icon"></i>
                                <?= Html::activeInput('date', $model, 'date_end', ['class' => 'form-control']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" style="max-width: 200px;">
                        <label class="form-label">Участников</label>
                        <div class="input-with-icon">
                            <i class="fas fa-users input-icon"></i>
                            <?= Html::activeInput('number', $model, 'count', [
                                'class' => 'form-control',
                                'min' => 1,
                                'max' => 20
                            ]) ?>
                        </div>
                    </div>
                </div>

                <!-- Оплата -->
                <div class="form-section">
                    <h3 class="form-section-title"><i class="fas fa-credit-card"></i> Способ оплаты</h3>
                    <div class="payment-options">
                        <div class="payment-option">
                            <?= Html::radio('Application[payment]', $model->payment == 0, [
                                'value' => 0,
                                'id' => 'paymentCash'
                            ]) ?>
                            <label for="paymentCash">
                                <div class="payment-icon payment-cash"><i class="fas fa-wallet"></i></div>
                                <div class="payment-info">
                                    <h5>Наличными</h5>
                                    <p>При получении</p>
                                </div>
                            </label>
                        </div>
                        <div class="payment-option">
                            <?= Html::radio('Application[payment]', $model->payment == 1, [
                                'value' => 1,
                                'id' => 'paymentCard'
                            ]) ?>
                            <label for="paymentCard">
                                <div class="payment-icon"><i class="fas fa-credit-card"></i></div>
                                <div class="payment-info">
                                    <h5>Картой</h5>
                                    <p>Онлайн</p>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Дополнительно -->
                <div class="form-section">
                    <h3 class="form-section-title"><i class="fas fa-comment"></i> Дополнительно</h3>
                    <div class="form-group textarea-container">
                        <?= Html::activeTextarea($model, 'additional', [
                            'class' => 'form-control',
                            'placeholder' => 'Особенности питания, аллергии, пожелания...'
                        ]) ?>
                        <div class="char-counter"><span id="charCount">0</span>/500</div>
                    </div>
                </div>

                <!-- Цена -->
                <div class="price-summary" id="priceSummary">
                    <div class="price-row">
                        <span>Стоимость тура:</span>
                        <span id="tourPrice">0 ₽</span>
                    </div>
                    <div class="price-row">
                        <span>Участников:</span>
                        <span id="participantsCount">–</span>
                    </div>
                    <div class="price-row total">
                        <span>Итого:</span>
                        <span id="totalPrice">0 ₽</span>
                    </div>
                </div>

                <button type="submit" class="submit-btn">
                    <i class="fas fa-paper-plane"></i> Отправить заявку
                </button>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const toursData = <?= json_encode(array_column($tours, 'title', 'id')) ?>;
    const toursPrices = <?= json_encode(array_column($tours, 'price', 'id')) ?>;
    const toursDuration = <?= json_encode(array_column($tours, 'duration', 'id')) ?>;

    const tourSelect = document.getElementById('tourSelect');
    const tourPreview = document.getElementById('tourPreview');
    const previewTitle = document.getElementById('previewTitle');
    const previewPrice = document.getElementById('previewPrice');
    const previewDuration = document.getElementById('previewDuration');

    const countInput = document.querySelector('input[name="Application[count]"]');

    const tourPriceEl = document.getElementById('tourPrice');
    const participantsEl = document.getElementById('participantsCount');
    const totalEl = document.getElementById('totalPrice');

    const textarea = document.querySelector('textarea[name="Application[additional]"]');
    const charCount = document.getElementById('charCount');

    function format(n) {
        return n.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
    }

    function updatePreview() {
        const id = tourSelect.value;
        if (!id || !toursData[id]) {
            tourPreview.classList.remove('active');
            document.getElementById('priceSummary').style.display = 'none';
            return;
        }

        previewTitle.textContent = toursData[id];
        previewPrice.textContent = format(toursPrices[id]) + ' ₽';
        previewDuration.textContent = toursDuration[id] || '7 дней';
        tourPreview.classList.add('active');
        document.getElementById('priceSummary').style.display = 'block';

        updateTotal();
    }

    function updateTotal() {
        const id = tourSelect.value;
        const count = parseInt(countInput.value) || 1;
        const price = toursPrices[id] || 0;
        const total = price * count;

        tourPriceEl.textContent = format(price) + ' ₽';
        participantsEl.textContent = count;
        totalEl.textContent = format(total) + ' ₽';
    }

    function setupCharCounter() {
        textarea.addEventListener('input', () => {
            const len = textarea.value.length;
            charCount.textContent = len;
            if (len > 500) {
                charCount.style.color = '#e74c3c';
                textarea.style.borderColor = '#e74c3c';
            } else if (len > 450) {
                charCount.style.color = '#f39c12';
            } else {
                charCount.style.color = '';
                textarea.style.borderColor = '';
            }
        });
    }

    // Ивенты
    tourSelect.addEventListener('change', updatePreview);
    countInput.addEventListener('input', updateTotal);
    setupCharCounter();

    // Инициализация
    updatePreview();
});
</script>